VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   7050
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   9705
   LinkTopic       =   "Form1"
   ScaleHeight     =   7050
   ScaleWidth      =   9705
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ComboBox cmbDamping 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   3390
      List            =   "fCairoDemo.frx":0013
      Style           =   2  'Dropdown-Liste
      TabIndex        =   3
      Top             =   120
      Width           =   1335
   End
   Begin VB.CheckBox chkClamp 
      Caption         =   "Clamp"
      Height          =   285
      Left            =   5070
      TabIndex        =   2
      Top             =   150
      Value           =   1  'Aktiviert
      Width           =   945
   End
   Begin VB.CheckBox chkMeetPoints 
      Caption         =   "Meet ControlPoints"
      Height          =   315
      Left            =   330
      TabIndex        =   1
      Top             =   150
      Value           =   1  'Aktiviert
      Width           =   1815
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   3945
      Left            =   90
      TabIndex        =   0
      Top             =   570
      Width           =   8175
      _ExtentX        =   14473
      _ExtentY        =   7646
   End
   Begin VB.Label Label1 
      Caption         =   "BSpline-Enum"
      Height          =   285
      Left            =   2310
      TabIndex        =   4
      Top             =   180
      Width           =   1215
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private CPs() As cControlPoint

Private Sub Form_Load()
  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels

Dim i&
  Rnd -9
  ReDim CPs(0 To 6)
  For i = 0 To UBound(CPs)
    Set CPs(i) = ucCanvas1.ControlPoints.Add("P" & i, i * 80 + 40, 100 + Rnd * 300, vbBlue)
  Next i
  
  'overwrite the default blue-color of the first and last ControlPoint
  CPs(0).Color = vbGreen: CPs(UBound(CPs)).Color = vbGreen
  
  cmbDamping.ListIndex = 3
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub chkMeetPoints_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub cmbDamping_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub chkClamp_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim i&, PolyArr() As Double
  'just a simple copy-over from the ControlPoint-Coords into a consecutive XY-PolyArray
  ReDim PolyArr(0 To 2 * ucCanvas1.ControlPoints.Count - 1)
  For i = 0 To UBound(CPs)
    PolyArr(2 * i) = CPs(i).X
    PolyArr(2 * i + 1) = CPs(i).Y
  Next i
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  CC.Save
    CC.TranslateDrawings 0.5, 0.5
    
    CC.SetLineCap CAIRO_LINE_CAP_ROUND
    CC.SetLineJoin CAIRO_LINE_JOIN_ROUND

    'just a demonstration of all the BSpline-relevant Parameters...
    'this wrapper-feature allows NURB-like construction of drawing-primitives
    CC.Polygon PolyArr, False, cmbDamping.ListIndex, (chkClamp.Value = 1), (chkMeetPoints.Value = 1)
      CC.SetSourceColor vbRed
      CC.SetLineWidth 4
    CC.Stroke
  CC.Restore
  
  ucCanvas1.Refresh '<- drawing of the current Control-points is "hidden" within this Refresh-method of the canvas
End Sub
